# switches abbreviation state of entityes in TFC based maps
# Version 2.0 by Zoner
#
# This file is a script, which requires a version of Perl to be installed so it may function.
#
# A Windows version of Perl can be obtained at http://www.activestate.com
#

$abbrev = 0; ## Default to expand

@srAbbrevs =
(
   '"g_a"',    '"goal_activation"',
   '"g_e"',    '"goal_effects"',
   
   '"rs_g"',   '"restore_goal_no"',
   '"rv_g"',   '"remove_goal_no"',
   '"rs_gr"',  '"restore_group_no"',
   '"rv_gr"',  '"remove_group_no"',
   '"rs_s_h"', '"restore_spawngroup"',
   '"rv_s_h"', '"remove_spawngroup"',

   '"a_s"',    '"ammo_shells"',
   '"a_n"',    '"ammo_nails"',
   '"a_r"',    '"ammo_rockets"',
   '"a_c"',    '"ammo_cells"',

   '"h_i_g"',  '"has_item_from_group"',
   '"r_i_g"',  '"remove_item_group"',

   '"d_t"',    '"team_drop"',
   '"d_n"',    '"non_team_drop"',
   '"d_n_t"',  '"netname_team_drop"',
   '"d_n_n"',  '"netname_non_team_drop"',

   '"b_b"',    '"broadcast"',
   '"b_t"',    '"team_broadcast"',
   '"b_n"',    '"non_team_broadcast"',
   '"b_o"',    '"owners_team_broadcast"',

   '"n_b"',    '"netname_broadcast"',
   '"n_t"',    '"netname_team_broadcast"',
   '"n_n"',    '"netname_non_team_broadcast"',
   '"n_o"',    '"netname_owners_team_broadcast"',

   '"t_s_h"',  '"team_str_home"',
   '"t_s_m"',  '"team_str_moved"',
   '"t_s_c"',  '"team_str_carried"',
   '"n_s_h"',  '"non_team_str_home"',
   '"n_s_m"',  '"non_team_str_moved"',
   '"n_s_c"',  '"non_team_str_carred"',

   '"i_p_t"',  '"info_player_teamspawn"',
   '"i_t_t"',  '"info_tfgoal_timer"',

   # The FGD uses i_t_g for brush based info_tfgoals to differentiate it between that and pointclass variety
   # WorldCraft can't handle multiple entitiy types of the same name even though they are different classes
#   '"i_t_g"',  '"info_tfgoal"',
);

sub Usage
{
print <<__FOO__
Syntax:
perl tfcabbrev.pl [-abbrev | -expand] mapfile

Ex: your map is called alpha.map and you want
to expand the abbreviations:

        perl tfcabbrev.pl -expand mapname

    and to convert them TO abbreviations:

        perl tfcabbrev.pl -abbrev mapname

The original map will be backed up to a file 
called mapname.bak

__FOO__
;
    exit 0;
}

sub main 
{
    $_ = $ARGV[0];
    if (($ARGV[0] eq "") || (/(\?|help)/i))
    {
        Usage();
    }

    local $mode = $ARGV[0];
    $_ = $mode;
    if (/expand/i)
    {
        $abbrev = 0;
    }
    elsif (/abbrev/i)
    {
        $abbrev = 1;
    }

    local $file = $ARGV[1];
    $file =~ s/\.map//i;

    local $oldfile = $file.".bak";
    local $newfile = $file.".map";

    rename($newfile, $oldfile) or die "Could not rename '$newfile' to '$oldfile'";

    local $i;
    local $nItems = $#srAbbrevs + 1;

    open (OLD, "<$oldfile");
    open (NEW, ">$newfile");

    while (<OLD>)
    {
        for ($i=0;$i<$nItems;$i+=2)
        {
            if ($abbrev)
            {
                s/$srAbbrevs[$i+1]/$srAbbrevs[$i]/gi;
            }
            else
            {
                s/$srAbbrevs[$i]/$srAbbrevs[$i+1]/gi;
            }
        }
        print NEW $_;
    }

    close(OLD);
    close(NEW);
}

&main;
